#pragma once

#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
#include <Adafruit_NeoPixel.h>
#include <I2Cdev.h>
#include <MPU6050.h>

#define OLED_RESET 4

#if (SSD1306_LCDHEIGHT != 64)
#error("Height incorrect, please fix Adafruit_SSD1306.h!");
#endif

struct vector3f {
  float x, y, z;
};

class BDK
{
public:
  BDK();
  Adafruit_SSD1306 display;
  uint16_t led_count = 16;
  Adafruit_NeoPixel strip;
  MPU6050 accelgyro;

  vector3f accel;
  vector3f gyro;

  float accel_intensity;
  float rotation;
  float pitch;

  void setPixelRGBA(uint16_t c, uint8_t r, uint8_t g, uint8_t b, uint8_t in_a);
  void setPixelRGBASub(uint16_t c, uint8_t in_s, uint8_t r, uint8_t g, uint8_t b, uint8_t in_a);
  void setPixel(float p, uint8_t r, uint8_t g, uint8_t b);
  void setPixel(float p, uint8_t r, uint8_t g, uint8_t b, uint8_t a);
  void setPixelHue(float p, uint16_t h, uint8_t s, uint8_t v);
  void setPixelHue(float p, uint16_t h, uint8_t s, uint8_t v, uint8_t a);
  void updateLEDs();
  void clearLEDs();
  void fadeLEDs(uint8_t in_a);
  void updateAccelerometer();

  bool touchTop();
  bool touchMiddle();
  bool touchBottom();
private:
  void init_screen();
  void init_leds();
  void init_mpu6050();

  uint16_t key_top_baseline = 0;
  uint16_t key_middle_baseline = 0;
  uint16_t key_bottom_baseline = 0;
};
